<?php
use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\Assets\Image;
use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Forms\TextField;
use SilverStripe\Forms\NumericField;
use SilverStripe\Forms\TreeDropdownField;
use SilverStripe\AssetAdmin\Forms\UploadField;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;
use SilverStripe\Forms\DropdownField;
use SilverStripe\ORM\DataObject;

class JobVacancy extends DataObject {

    private static $singular_name = "Vacancy";

    private static $db = array(
        "Title"         => "Varchar",
        "Salary"        => "Text",
        "Content"       => "HTMLText",
    );


    private static $has_one = array(
        "CareersPage" => CareersPage::class
    );

    private static $fullOnly = true;

    public function getCMSFields(){

        $fields = parent::getCMSFields();
        $fields->removeByName("CareersPageID");

        $fields->addFieldToTab("Root.Main", new TextField("Title", "Title"));
        $fields->addFieldToTab("Root.Main", new TextField("Salary", "Salary (£)"));

        $HTML = HTMLEditorField::create('Content', 'Content')
            ->setRows(5);
        $fields->addFieldToTab('Root.Main', $HTML);

        return $fields;
    }

}
