<?php

use SilverStripe\Admin\ModelAdmin;
use SilverStripe\Forms\GridField\GridField;
use SilverStripe\Forms\GridField\GridFieldConfig;
use SilverStripe\Forms\GridField\GridFieldAddNewButton;
use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
use Symbiote\GridFieldExtensions\GridFieldAddNewInlineButton;
use Symbiote\GridFieldExtensions\GridFieldEditableColumns;

class FontAwesomeAdmin extends ModelAdmin {

	private static $managed_models = array(   //since 2.3.2
		'FontAwsomeIcon'
	);

	private static $url_segment = 'icon'; // will be linked as /admin/products
	private static $menu_title = 'Icons';
    private static $menu_icon_class = 'fas fa-flag';



    public function getEditForm($id = null, $fields = null) {

        $form = parent::getEditForm($id, $fields);

        // Event specific settings
        if($this->modelClass == 'FontAwsomeIcon') {

            $gridFieldName = $this->sanitiseClassName($this->modelClass);
            $gridField = $form->Fields()->fieldByName($gridFieldName);

            $config = $gridField->getConfig();

            // Configure 'Add New' button text
            // $config->removeComponentsByType($config->getComponentByType(GridFieldAddNewButton::class));
            // $config->removeComponentsByType($config->getComponentByType('GridFieldDeleteAction'));

            // $config->addComponent(new GridFieldAddNewInlineButton());
            // $config->addComponent(new GridFieldEditableColumns());
        }

        return $form;

    }    

}
