<?php
use SilverStripe\Forms\GridField\GridFieldConfig;
use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use SilverStripe\Forms\GridField\GridFieldConfig_RelationEditor;
use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
use SilverStripe\Forms\GridField\GridFieldAddNewButton;
use SilverStripe\Forms\GridField\GridField;
use SilverStripe\Forms\Tab;
use SilverStripe\Forms\DateField;
use SilverStripe\AssetAdmin\Forms\UploadField;
use SilverStripe\Assets\Image;
use TractorCow\Colorpicker\Forms\ColorField;
use SilverStripe\View\Requirements;
use SilverStripe\Forms\TextField;
use SilverStripe\TagField\TagField;
use SilverStripe\Forms\DropdownField;

class CaseStudyDetailPage extends Page {

    private static $db = array(
        "SubTitle"      => "Text",
    );

    private static $many_many = array(
        "Categories"            => "Categories",
    );

    private static $has_one = array(
        "Image"     => Image::class,
        "logo"      => Image::class,
    );
    
    private static $owns = [
        'Image',
        'logo',
    ];

    private static $default_blocks = array(
        "Banner Row"   => array(
            "BlockWidgetInternalBanner"
        ),
        "Feature Text & Checklist Row"   => array(
            "BlockWidgetFeatureText" => "2",
            "BlockWidgetChecklist" => "1",
        ),
        "Testimonials Carousel Row"   => array(
            "BlockWidgetTestimonialsCarousel"
        ),  
        "Image Text & Icon Row 1"   => array(
            "BlockWidgetImageTextIcon"
        ),
        "Image Text & Icon Row 2"   => array(
            "BlockWidgetImageTextIcon"
        ),                      
        "Full Width CTA Row"   => array(
            "BlockWidgetFullWidthCTA"  => "No"
        ),                          
     );
    
    public function getCMSFields(){

        $fields = parent::getCMSFields();

        $fields->addFieldToTab("Root.Main", new TextField("SubTitle", "Sub Title"),'URLSegment');
        $fields->addFieldToTab("Root.Main", new UploadField("Image", "Image"),'URLSegment');
        $fields->addFieldToTab("Root.Main", new UploadField("logo", "Logo"),'URLSegment');

        $Categories = TagField::create(
            'Categories',
            'Categories',
            Categories::get(),
            $this->Categories()
        )
            ->setShouldLazyLoad(true) // tags should be lazy loaded
            ->setCanCreate(false);
        $fields->addFieldToTab('Root.Categories', $Categories);

        return $fields;
    }
}
class CaseStudyDetailPage_Controller extends PageController {

    private static $allowed_actions = array (
    );

    public function init() {
        parent::init();
        // You can include any CSS or JS required by your project here.
        // See: http://doc.silverstripe.org/framework/en/reference/requirements
    }

}
