<?php
namespace FormFields;

use SilverStripe\ORM\DataObject;
use FormFields\CustomisableFormField;
use FormFields\BlockWidgetCustomisableForm;

class CustomisableFormPanel extends DataObject {
	private static $db = array(
		"Title" => "Varchar",
		"Sort"  => "Int"
	);

	private static $table_name = 'CustomisableFormPanel';

	private static $has_one = array(
		"CustomisableForm"  => BlockWidgetCustomisableForm::class
	);

	private static $has_many = array(
		"FormFields"    => CustomisableFormField::class
	);

	private static $default_sort = "Sort";

	public function getCMSFields()
	{
		$fields = parent::getCMSFields();
		$fields->removeByName("Sort");
		$fields->removeByName("FormFields");
		$fields->removeByName("CustomisableFormID");
		return $fields;
	}

	public function Output(){

	}

}