<?php
namespace FormFields;
use FormFields\CustomisableFormOptionField;

use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
use Symbiote\GridFieldExtensions\GridFieldAddNewInlineButton;
use Symbiote\GridFieldExtensions\GridFieldEditableColumns;
use SilverStripe\Forms\GridField\GridFieldAddNewButton;
use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use SilverStripe\Forms\GridField\GridFieldDataColumns;
use SilverStripe\Forms\GridField\GridFieldConfig;
use SilverStripe\Forms\GridField\GridField;
use SilverStripe\Forms\OptionsetField;

class CustomisableRadioField extends CustomisableFormOptionField
{
	private static $singular_name = "Radio Button Field";

	private static $db = array();

	private static $has_one = array(
	);

	private static $has_many = array(
	);

	private static $remove_from_list = false;

	private static $base_field_type = OptionsetField::class;

	private static $table_name = 'CustomisableRadioField';

	private static $has_options = true;

	public function getCMSFields()
	{
		$fields = parent::getCMSFields();
		$fields->removeByName("Options");
		$fields->removeByName("UploadField");
		$fields->removeByName("PrerequisiteFieldValues");
		if($this->ID){
			//this removes the float and position from unwanted fields
			$fields->removeByName("Icon");
			$fields->removeByName("Float");
			//this gets the options
			$gridFieldConfig = GridFieldConfig_RecordEditor::create();
			$gridFieldConfig->removeComponentsByType(GridFieldDataColumns::class);
			$gridFieldConfig->addComponent(new GridFieldOrderableRows());
			$gridFieldConfig->addComponent(new GridFieldEditableColumns());
			$gridFieldConfig->addComponent(new GridFieldAddNewInlineButton());
			$gridFieldConfig->removeComponentsByType(GridFieldAddNewButton::class);

			$grid = new GridField("Options", "Options", $this->Options(), $gridFieldConfig);
			$fields->addFieldToTab("Root.Main", $grid);
		}

		return $fields;
	}

	public function getCustomField(){
		// $field = parent::getCustomField(); //This calls getCustomField from CustomisableFormField
		$fieldType = $this->stat('base_field_type'); //gets SilverStripe\Forms\TextField
		$sourceData = $this->Options()->sort("Sort")->map("ID", "Title")->toArray();
		$field = new $fieldType($this->getDataFieldTitle(), $this->Title, $sourceData); //creates SilverStripe\Forms\TextField Object ()		
		$field->setSource($sourceData);
		if ($this->Required){
			$field->setAttribute("required", "required");
		}		
		return $field;
	}

	public function parseValue($value){
		if ($chosenOption = $this->Options()->filter(array("ID" => $value))->First()){
			return $chosenOption->Title;
		}
		return "Not Provided";
	}
}