<?php

use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use SilverStripe\Forms\GridField\GridField;
use SilverStripe\Forms\GridField\GridFieldAddNewButton;

class TestimonialsPage extends Page {

    private static $db = array(
    );

    private static $has_many = array(
        "Testimonials"      => "TestimonialItem"
    );

    private static $default_blocks = array(
        "Banner Row"   => array(
            "BlockWidgetInternalBanner"
        ),
        "Testimonial and CTA"  => array(
            "BlockWidgetTestimonialsList" => "2",
            "BlockWidgetTestimonialForm" => "1",              
        ),                                  
     );

    public function getCMSFields()
    {
        $fields = parent::getCMSFields();
        if ($this->ID > 0) {
            $gridFieldConfig = GridFieldConfig_RecordEditor::create();
            $gridFieldConfig->addComponent(new GridFieldOrderableRows("SortOrder"));
            $grid = new GridField("Testimonials", "Testimonials", $this->Testimonials(), $gridFieldConfig);
            $fields->addFieldToTab("Root.Testimonials", $grid);
        }
        return $fields;
    }

}
class TestimonialsPage_Controller extends PageController {

    /**
    * An array of actions that can be accessed via a request. Each array element should be an action name, and the
    * permissions or conditions required to allow the user to access it.
    *
    * <code>
    * array (
    *     'action', // anyone can access this action
    *     'action' => true, // same as above
    *     'action' => 'ADMIN', // you must have ADMIN permissions to access this action
    *     'action' => '->checkAction' // you can only access this action if $this->checkAction() returns true
    * );
    * </code>
    *
    * @var array
    */
    private static $allowed_actions = array (
    );

    public function init() {
        parent::init();
        // You can include any CSS or JS required by your project here.
        // See: http://doc.silverstripe.org/framework/en/reference/requirements
    }

}
