<?php

use SilverStripe\ORM\DataExtension;
use SilverStripe\Forms\FieldList;
use SilverStripe\Forms\EmailField;
use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use SilverStripe\Forms\GridField\GridField;

class TestimonialsSiteConfigExtension extends DataExtension {
	private static $has_many = array(
		"TestimonialsRecipients"    => TestimonialsRecipient::class
	);

	private static $db = array(
		"TestimonialsNotificationFrom"      => "Varchar(200)"
	);

	public function updateCMSFields(FieldList $fields)
	{
		$fields->addFieldToTab("Root.Testimonials", new EmailField("TestimonialsNotificationFrom", "Testimonials Notification From Address"));
		$gridFieldConfig = GridFieldConfig_RecordEditor::create();
		$grid = new GridField("TestimonialsRecipients", "TestimonialsRecipients", $this->owner->TestimonialsRecipients(), $gridFieldConfig);
		$fields->addFieldToTab("Root.Testimonials", $grid);
	}
}