<?php

use SilverStripe\ORM\DataObject;

class TestimonialItem extends DataObject
{
	private static $singular_name = "Testimonial";

	private static $db = array(
		"Title"     => "Varchar(50)",
		"Content"   => "Text",
		"Author"    => "Varchar(150)",
		"Location"  => "Varchar(75)",
		"Rating"    => "Enum(array('1','2','3','4','5'))",
		"Approved"  => "Boolean",
		"AddToHome"  => "Boolean",
		"SortOrder" => "Int"
	);

	private static $default_sort = "SortOrder";

	private static $has_one = array(
		"Page"  => "TestimonialsPage"
	);

	private static $summary_fields = array(
		"Title",
		"Rating",
		"IsApproved", //gets function
		"AddToHomePage", //gets function
	);
    // private static $casting = [
    //     'getAddToHomePage' 	=> 'Boolean'
    //     'getIsApproved' 	=> 'Boolean'
    // ];
	//each icon represents the rating
	// public function getDisplayIcon(){
	// 	switch($this->Rating){
	// 		case "1":
	// 			return "images/icons/rating/1.svg";
	// 		case "2":
	// 			return "images/icons/rating/2.svg";
	// 		case "3":
	// 			return "images/icons/rating/3.svg";
	// 		case "4":
	// 			return "images/icons/rating/4.svg";
	// 		case "5":
	// 			return "images/icons/rating/5.svg";
	// 	}
	// }

	//need however many icons per rating
	public function getDisplayIcon(){
		switch($this->Rating){
			case "1":
				return "1";
			case "2":
				return "2";
			case "3":
				return "3";
			case "4":
				return "4";
			case "5":
				return "5";
		}
	}

	public function getAddToHomePage(){
		switch($this->AddToHome){
			case true:
				return "Yes";
			break;
			case false:
				return "No";
		}
	}

	public function getIsApproved(){
		switch($this->Approved){
			case true:
				return "Yes";
			break;
			case false:
				return "No";
		}
//		return ($this->Approved ? "Yes":"No");
	}

	private static $has_many = array();

    private static $belongs_many_many = array(
        "BlockWidgetTestimonialsCarousel"      => BlockWidgetTestimonialsCarousel::class,
    );

	public function getCMSFields()
	{
		$fields = parent::getCMSFields();
		$fields->removeByName("PageID");
		$fields->removeByName("BlockWidgetTestimonialsCarouselID");
		$fields->removeByName("SortOrder");
		return $fields;
	}

	public function getElementID(){
		return $this->ClassName . '_' . $this->ID;
	}
}