<?php

use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Forms\TextField;
use SilverStripe\AssetAdmin\Forms\UploadField;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;
use SilverStripe\Forms\DropdownField;
use SilverStripe\Forms\LiteralField;

class BlockWidgetTestimonials extends PageBlock {

    private static $singular_name = "Testimonials Feature Block";

    private static $db = array(
        "Title"     => "Text",
        "Content"   => "HTMLText",
        "Info"      => "Text",
    );

    private static $fullOnly = true;

    private static $allowed_page_types = array();

    private static $has_one = array(
        "TargetPage" => SiteTree::class
    );

    private static $many_many = array(
        // "Testimonials"  => TestimonialItem::class
    );

    public function getCMSFields(){
        $fields = parent::getCMSFields();
        $fields->removeByName("Testimonials");

        $fields->addFieldToTab("Root.Main", new TextField("Title", "Title"));
        $fields->addFieldToTab("Root.Main", new HtmlEditorField("Content", "Content"));
        $fields->addFieldToTab("Root.Main", $target = DropdownField::create("TargetPageID", "TargetPage", Page::get()->sort("Title")->map()->toArray()));
        $target->setEmptyString("Select a target page");        

        $fields->addFieldToTab("Root.Main", new LiteralField("Info", 'Testimonials can be added from the testimonials admin <a href="/admin/testimonialsadmin/">here</a>'));


        return $fields;
    }

    public function Output(){
        return parent::Output();
    }

    public function getApprovedTestimonials(){
        // return $this->Testimonials()->filter(array("Approved"   => true , "AddToHome" => true));
        $testimonials = TestimonialItem::get()->filter(array("Approved"   => true , "AddToHome" => true));
        if (isset($testimonials)) {
            return $testimonials;
        }
    }

}
