<?php

use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\Assets\Image;
use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Forms\TextField;
use SilverStripe\Forms\TreeDropdownField;
use SilverStripe\AssetAdmin\Forms\UploadField;
use TractorCow\Colorpicker\Forms\ColorField;
use SilverStripe\Forms\DropdownField;

class BlockWidgetImageCTA extends PageBlock {

	private static $singular_name = "Image CTA Block";

    private static $db = array(
        "Title"       => "Varchar(50)",
        // "Content"       => "HTMLText",
        "ButtonText"   => "HTMLText",
        "BackgroundColour" => "Color"
    );

    private static $defaults = array(
           'Title'      => "Enter a title in the CMS",
           // 'Content'    => "Eget aliquet nibh praesent.",         
           'ButtonText' => "Read more about us",        
           // 'BackgroundColour' => "8dd619",        
    );

    private static $fullOnly = false;

    private static $has_one = array(
        "TargetPage"    => SiteTree::class,
        "Image"         => Image::class,
    );
    
    private static $owns = [
        'Image'
    ];

    public function getCMSFields()
        {
            $fields = parent::getCMSFields();
            $fields->removeByName("LinkTracking");
            $fields->removeByName("FileTracking");            
            $fields->addFieldToTab("Root.Main", new TextField("Title", "Title"));
            // $fields->addFieldToTab("Root.Main", new TextField("Content", "Content"));
            $fields->addFieldToTab("Root.Main", new TextField("ButtonText", "ButtonText"));
            $fields->addFieldToTab("Root.Main", $target = DropdownField::create("TargetPageID", "TargetPage", Page::get()->sort("Title")->map()->toArray()));
            $target->setEmptyString("Select a target page");
            $fields->addFieldToTab("Root.Main", new ColorField ("BackgroundColour", "CTA background colour (optional)"));
            $fields->addFieldToTab("Root.Main", new UploadField("Image", "Image"));
            return $fields;
        }

    public function Output()
        {
    //      Requirements::css("themes/" . Config::inst()->get('SSViewer', 'theme') . "/css/.css");
    //      Requirements::javascript("themes/" . Config::inst()->get('SSViewer', 'theme') . "/javascript/.js");
            return parent::Output();
        }

}