<?php

namespace NewedgeMedia\MenuManager;

use SilverStripe\View\TemplateGlobalProvider;

class MenuManagerTemplateProvider implements TemplateGlobalProvider {
	public static function get_template_global_variables() {
		return array(
			'ControlledMenu',
			'ControlledCTAs'
		);
	}
	public static function ControlledMenu($menu = false) {
		if ($menu){
			return Menu::get()->filter(
				array(
					"Name" => $menu
				)
			)->First();
		} else {
			return Menu::get();
		}
	}

	public static function ControlledCTAs(){
		return MenuCTA::get();
	}
}