<?php
namespace NewedgeMedia\MenuManager;

use SilverStripe\Admin\ModelAdmin;
use SilverStripe\ORM\DataObject;

class MenuManager extends ModelAdmin {
	private static $managed_models = array(
		Menu::class,
		MenuCTA::class
	);

	private static $url_segment = 'MenuManager';

	private static $menu_title = 'Menu Manager';

	public function getEditForm($id = null, $fields = null) {
		$form = parent::getEditForm($id, $fields);

		// $gridFieldName is generated from the ModelClass, eg if the Class 'Product'
		// is managed by this ModelAdmin, the GridField for it will also be named 'Product'

		$gridFieldName = $this->sanitiseClassName($this->modelClass);
		$gridField = $form->Fields()->fieldByName($gridFieldName);

		// modify the list view.
//		$gridField->getConfig()->addComponent(new GridFieldResendButton());

		return $form;
	}

//	public function getEditForm($id = null, $fields = null)
//	{
//		$form = parent::getEditForm($id, $fields); // TODO: Change the autogenerated stub
//		$menus =  Config::inst()->get('SiteTreeMenuExtension', 'menus');
//		$menuTabSet = new TabSet("Menus");
//		foreach($menus as $menu){
//			$menuTabSet->push(new Tab($menu));
//		}
//		$actions = $form->Actions();
//		$actions->removeByName('Save');
//		return $form;
//	}
}