<?php

namespace NewedgeMedia\BlockBuilder;

use SilverStripe\ORM\DataExtension;
use SilverStripe\ORM\DataObject;
use SilverStripe\Forms\FieldList;
use SilverStripe\Forms\LiteralField;
use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use SilverStripe\Forms\GridField\GridField;
use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
use SilverStripe\Forms\TextareaField;
use SilverStripe\Control\Session;
use SilverStripe\Core\Injector\Injector;
use SilverStripe\Control\HTTPRequest;
use SilverStripe\Control\Controller;
use SilverStripe\Dev\Deprecation;
use SilverStripe\Core\Config;
use SilverStripe\Core\Config\Configurable;

class BlockBuilder extends DataExtension {

    private static $indexes = array(
//        'Title' => array(
//            'type' => 'Fulltext',
//            'name' => 'TitleIndex',
//            'value' => '"Title"',
//        ),'Keywords' => array(
//            'type' => 'Fulltext',
//            'name' => 'KeywordsIndex',
//            'value' => '"Keywords"',
//        )
    );

    private static $create_table_options = array(
        'MySQLDatabase' => 'ENGINE=MyISAM'
    );

    private static $db = array(
        "Keywords"          => "Text",
        "UseBlockBuilder"   => "Boolean"
    );

    public static $has_one = array(
    );

    private static $has_many = array(
        "PageBlockRows"    => PageBlockRow::class
    );

    public function updateCMSFields(FieldList $fields) {
        // only show block bulder on selected pages
        // if all pages want block builder, then set the var on SiteTree.
            if ($this->owner->config()->UseBlockBuilder){
                $fields->removeByName("Content");
                if ($this->owner->ID > 0) {
                    $fields->addFieldToTab("Root.Main", new LiteralField("Content", "Page Blocks"), "Metadata");
                    $gridFieldConfig = GridFieldConfig_RecordEditor::create();
                    $gridFieldConfig->addComponent(new GridFieldOrderableRows('SortOrder'));
                    $grid = new GridField('PageBlockRows', 'Page Block Rows', $this->owner->PageBlockRows(), $gridFieldConfig);
                    $fields->addFieldToTab('Root.Main', $grid, "Metadata");
                }
                $fields->addFieldToTab("Root.Search", $keywordsField = new TextareaField("Keywords"));
                $keywordsField->setRows(10);
                $keywordsField->setColumns(20);
            }
    }

    public function onBeforeWrite(){
        parent::onBeforeWrite();
//		check if page new
        if (!$this->owner->isInDB() && $this->owner->config()->UseBlockBuilder){
            $request = Controller::curr()->getRequest();
            $request->getSession()->set('CreateDefaultBlocks', true);
        }
    }

    public function onAfterWrite(){
        $request = Injector::inst()->get(HTTPRequest::class);
        $session = $request->getSession();
        if ($session->get("CreateDefaultBlocks") && $this->owner->config()->UseBlockBuilder){
            $session->clear("CreateDefaultBlocks");
            $class = $this->owner->ClassName;
            $blocks = $class::config()->default_blocks;
            // echo '<pre>' . print_r($blocks, true) . '</pre>';die();

            if (count($blocks) > 0){
                foreach($blocks as $row => $blocks){ //$row = banner row // $blocks = InternalBannerBlock
                    $newRow = new PageBlockRow();
                    $newRow->Name = $row;
                    $this->owner->PageBlockRows()->add($newRow);
                    foreach($blocks as $block   => $width){
                        if (is_int($block)){
                            $block = $width;
                            $width = 0;
                        }
                        if (class_exists($block)){
                            if($width == "x3" && !singleton($block)->config()->fullOnly){ //if x3 and not != fullOnly
                                $newBlock = new $block;
                                $newBlock->Name = "New " . $newBlock->i18n_singular_name();
                                $newBlock->write();
                                $newRow->PageBlocks()->add($newBlock); //block 1

                                $newBlock1 = new $block;
                                $newBlock1->Name = "New " . $newBlock1->i18n_singular_name();
                                $newBlock1->write();
                                $newRow->PageBlocks()->add($newBlock1); //block 2

                                $newBlock2 = new $block;
                                $newBlock2->Name = "New " . $newBlock2->i18n_singular_name();
                                $newBlock2->write();
                                $newRow->PageBlocks()->add($newBlock2); //block 3

                                unset($newBlock);
                                unset($newBlock1);
                                unset($newBlock2);

                            }elseif($width == "x2" && !singleton($block)->config()->fullOnly){ //if x3 and not != fullOnly do 50/50 in a row
                                $newBlock = new $block; //block 1
                                $newBlock->Name = "New " . $newBlock->i18n_singular_name();
                                $newBlock->OverrideWidth = "2";
                                $newBlock->write();
                                $newRow->PageBlocks()->add($newBlock); 

                                $newBlock1 = new $block; //block 2
                                $newBlock1->Name = "New " . $newBlock1->i18n_singular_name();
                                $newBlock1->OverrideWidth = "2";
                                $newBlock1->write();
                                $newRow->PageBlocks()->add($newBlock1);

                                unset($newBlock);
                                unset($newBlock1);
                            }elseif($newBlock = new $block){
                                $newBlock->Name = "New " . $newBlock->i18n_singular_name();
                                $newBlock->write();

                                if ($width > 0 && !singleton($block)->config()->fullOnly){
                                    $newBlock->OverrideWidth = $width;
                                }

                                $newRow->PageBlocks()->add($newBlock); //block 1 or if x3 it will be block 3

                                unset($newBlock);

                            }
                        } else {
//                            echo $block;
//                            die();
                        }
                    }

                }
            }
        }
        parent::onAfterWrite();
    }
}



// if ($newBlock = new $block){
//     $newBlock->Name = "New " . $newBlock->i18n_singular_name();
//     $newBlock->write();

//     if ($width > 0 && !singleton($block)->config()->fullOnly){
//         $newBlock->OverrideWidth = $width;
//     }

//     $newRow->PageBlocks()->add($newBlock); //block 1 or if x3 it will be block 3
// }                                