<?php
namespace NewedgeMedia\BlockBuilder;

use SilverStripe\ORM\DataObject;
use SilverStripe\Forms\RequiredFields;
use SilverStripe\Forms\GridField\GridField;
use SilverStripe\Forms\GridField\GridFieldConfig;
use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
use Symbiote\GridFieldExtensions\GridFieldAddNewMultiClass;
use SilverStripe\SiteConfig\SiteConfig;
use SilverStripe\View\Requirements;
use SilverStripe\Core\ClassInfo;
use NewedgeMedia\BlockBuilder\GridFieldConfig_PageBlock;
use Page;

class PageBlockRow extends DataObject {


	private static $db = array(
		"Name"      => 'Varchar(255)',
		"SortOrder" => 'Int'
	);

	// One-to-one relationship with gallery page
	private static $has_one = array(
		'Page'      => Page::class
	);

	private static $has_many = array(
		"PageBlocks"    => PageBlock::class
	);

	private static $defaults = array(
	);
	
    private static $table_name = 'PageBlockRow';
	


	// tidy up the CMS by not showing these fields
	public function getCMSFields() {
		$fields = parent::getCMSFields();
		Requirements::css(BLOCK_BUILDER_DIR.'/css/cms.css');
		$fields->removeFieldFromTab("Root.Main","PageID");
		$fields->removeFieldFromTab("Root.Main","SortOrder");
		$fields->removeByName("LinkTracking");
		$fields->removeByName("FileTracking");		
		$fields->removeByName("PageBlocks");
		if ($this->ID > 0){
			$gridFieldConfig = GridFieldConfig_PageBlock::create();
			$gridFieldConfig->addComponent(new GridFieldOrderableRows('SortOrder'));

			// $gridFieldConfig->getConfig()->addComponent(new GridFieldOrderableRows('SortOrder'));
			// $gridField->getConfig()->addComponent(new GridFieldOrderableRows('SortOrder'));
			if ($this->PageBlocks()->Count() < 3){
				$fullWidthItem = false;
				foreach($this->PageBlocks() as $block){
					$class = $block->ClassName;
					if (singleton($class)->config()->fullOnly){
						$fullWidthItem = true;
					}
				}
				if (!$fullWidthItem){
					$gridFieldConfig->addComponent($multiField = new GridFieldAddNewMultiClass('buttons-before-left'));
					$classes = ClassInfo::subclassesFor(PageBlock::class);
					$classes = array_combine(array_values($classes), array_values($classes));
					unset($classes[PageBlock::class]); // If you don't want 'MyDataObject' itself included
					foreach ($classes as $name => $class){
						$class = singleton($name);
						$classes[$name] = $class->i18n_singular_name();
						if ($class->config()->fullOnly){
	//				        check if there are other blocks (at all) and remove this option if there are.
							if ($this->PageBlocks()->Count() > 0){
								unset($classes[$name]);
							}
						}
	//					check if only allowed on some pagetypes
						if (count($class->config()->allowed_page_types) > 0 && !in_array($this->Page()->ClassName, $class->config()->allowed_page_types)){
							unset($classes[$name]);
						}
						$theme 	= SiteConfig::current_site_config()->Theme;
						$allowed_templates = $class->config()->allowed_templates;
						if ((is_array($allowed_templates)) && (count($allowed_templates) > 0) && (!in_array($theme, $allowed_templates))) {
							unset($classes[$name]);
						}
					}
					asort($classes);
	//				loop through all classes again and reset the value to the key.
					foreach ($classes as $className => $Title) {
						$classes[$className] = $className;
					}
					// echo '<pre>' . print_r($classes, true) . '</pre>';die();
					$addNew = $gridFieldConfig->getComponentByType(GridFieldAddNewMultiClass::class);
					$addNew->setClasses(array_values($classes));
					$addNew->setTitle("Add Page Block");
					// echo '<pre>' . print_r($addNew, true) . '</pre>';die();
					
				}
			}

	//		also need to control available types based on the blocks added. If there is
			$grid = new GridField('PageBlocks','PageBlocks', $this->PageBlocks() ,$gridFieldConfig);
//			$grid->getConfig()->getComponentByType(GridFieldDetailForm::class)->setValidator(singleton(PageBlock::class)->getCMSValidator());


			$fields->addFieldToTab('Root.Main', $grid);
		}

		$this->extend('updateCMSFields', $fields);

		return $fields;
	}

	// Tell the datagrid what fields to show in the table
	private static $summary_fields = array(
		'Name' => 'Name'
	);
	public function getCMSValidator() {
		return new PageBlockRow_Validator();
	}

	public function getValidator() {
		return new PageBlockRow_Validator();
	}

    public function canCreate($member = null, $context = array()){
        return true;
    }

    public function canEdit($member = null, $context = array()){
        return true;
    }    

    public function canView($member = null, $context = array()){
        return true;
    }
    public function canDelete($member = null, $context = array()){
        return true;
    }     	
}

class PageBlockRow_Validator extends RequiredFields {
	function php($data) {
		$bRet = parent::php($data);
		// if (empty($data['Name'])) {
		//     $this->validationError('Name','Name is required',"required");
		//     $bRet = false;
		// }

		// if (empty($data['Content'])) {
		//  $this->validationError('Content','Content is required',"required");
		//  $bRet = false;
		// }

		return $bRet;
	}
}