<?php
use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\Assets\Image;
use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Forms\TextField;
use SilverStripe\Forms\TreeDropdownField;
use SilverStripe\AssetAdmin\Forms\UploadField;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;
use TractorCow\Colorpicker\Forms\ColorField;
use SilverStripe\Forms\DropdownField;
use SilverStripe\Forms\CheckboxField;

class BlockWidgetTextImage extends PageBlock {

    private static $singular_name = "Text and Image Block";
    
    private static $fullOnly = true;

    private static $customCSS = true;

	private static $db = array(
		'Title'             => 'Varchar',
		'Content'           => 'HTMLText',
		"TitleTag"          => "Enum(array('h1','h2','h3', 'h4'))",
		"ImageAlignments"   => "Enum(array('Left','Right'))",
		"RowStructure"      => "Enum(array('Default (Text 1/2 & Image 1/2)','Text 1/3 & Image 2/3', '2/3 Text & 1/3 Image'))",
		"BackgroundColour" 	=> "Color",
        "TitleColour" 		=> "Color",
        "ContentColour" 	=> "Color",
        'ButtonText'        => 'Varchar',

	);

    private static $defaults = array(
           'Title' => "Enter a title in the CMS",
           'Content' => "Eget aliquet nibh praesent tristique magna sit amet purus. Semper viverra nam libero justo laoreet sit amet cursus sit. Ultricies mi quis hendrerit dolor magna eget. Mollis aliquam ut porttitor leo a diam sollicitudin tempor id. Suspendisse ultrices gravida dictum fusce. Euismod elementum nisi quis eleifend quam adipiscing vitae. Odio aenean sed adipiscing diam donec. Sapien pellentesque habitant morbi tristique senectus et netus. Tristique senectus et netus et malesuada fames ac turpis egestas. In iaculis nunc sed augue. Ac tortor dignissim convallis aenean et tortor at risus viverra. Porta non pulvinar neque laoreet suspendisse interdum consectetur. Erat pellentesque adipiscing commodo elit at imperdiet. Venenatis cras sed felis eget velit. Rutrum quisque non tellus orci. Id diam maecenas ultricies mi eget mauris. Donec massa sapien faucibus et.",           
    );

	private static $has_one = array(
        "Image"         => Image::class,
		"TargetPage"    => SiteTree::class,
	);

    private static $owns = [
        'Image'
    ];

    public function getDisplayTag(){
        switch($this->TitleTag){
            case "h1":
                return "h1";
            case "h2":
                return "h2";
            case "h3":
                return "h3";
            case "h4":
                return "h4";
            default:
                return "h1";
        }
    }

    public function getImageAlignment(){
        switch($this->ImageAlignments){
            case "Left":
                return "Left";
            case "Right":
                return "Right";
        }
    }

    public function getStructure(){
        switch($this->RowStructure){
            case "Default (Text 1/2 & Image 1/2)":
                return "Default";
            case "Text 1/3 & Image 2/3":
                return "TextOneThird";
            case "2/3 Text & 1/3 Image":
                return "TextTwoThird";
        }
    }

    public function getElementID(){
        return $this->ClassName . '_' . $this->ID . '_' . $this->ID;
    }

    public function getCustomCSS(){
        $customCSS = array();
        $selector =$this->getElementID();
        // The title colour is inlined styled in the template because of the display tag element. can be h1,h2,h3 or h4.
        // Text
        $customCSS["{$selector} p"] = array();
        $customCSS["{$selector} p"][] = array(
            "Title" => "{$selector} p",
            "CSS"   => "color:#{$this->owner->ContentColour};",
        );
        return $customCSS;
    }

	function getCMSFields() {
		$fields = parent::getCMSFields();
        $fields->addFieldToTab('Root.Image', new DropdownField(
              'ImageAlignments',
              'ImageAlignments',
              singleton('BlockWidgetTextImage')->dbObject('ImageAlignments')->enumValues()
            ));
        $fields->addFieldToTab("Root.Image", new UploadField("Image", "Image"));

        $fields->addFieldToTab('Root.Main', new DropdownField(
              'TitleTag',
              'TitleTag',
              singleton('BlockWidgetTextImage')->dbObject('TitleTag')->enumValues()
            ));
        $fields->addFieldToTab("Root.Main", new TextField("Title", "Title"));
        $fields->addFieldToTab("Root.Main", new HtmlEditorField("Content", "Content"));

        $fields->addFieldToTab("Root.Button", new TextField("ButtonText", "Button Text"));
        $fields->addFieldToTab("Root.Button", $target = DropdownField::create("TargetPageID", "TargetPage", Page::get()->sort("Title")->map()->toArray()));
        $target->setEmptyString("Select a target page");


        $fields->addFieldToTab('Root.RowStructure', new DropdownField(
              'RowStructure',
              'Row structure',
              singleton('BlockWidgetTextImage')->dbObject('RowStructure')->enumValues()
            ));
         $fields->addFieldToTab("Root.RowStructure", new ColorField("BackgroundColour", "Row background colour"));
         $fields->addFieldToTab("Root.RowStructure", new ColorField("TitleColour", "Title colour"));
         $fields->addFieldToTab("Root.RowStructure", new ColorField("ContentColour", "Body text colour"));

		return $fields;
	}
}