<?php
// namespace NewedgeMedia\BlockBuilder;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;
use SilverStripe\Control\Controller;
use SilverStripe\ORM\DataObject;
use NewedgeMedia\BlockBuilder\PageBlock;

class BlockWidgetText extends PageBlock {

	private static $db = array(
		'Title'         => 'Varchar',
		"TitleTag"          => "Enum(array('h1','h2','h3', 'h4'))",
		'Content'       => 'HTMLText',
		
	);

    private static $table_name = 'BlockWidgetText';
	
	private static $singular_name = "Text Block";

	public function getDisplayTag(){
		switch($this->TitleTag){
			case "h1":
				return "h1";
			case "h2":
				return "h2";
			case "h3":
				return "h3";
			case "h4":
				return "h4";
			default:
				return "h1";
		}
	}

    private static $defaults = array(
           'Title' => "Enter a title in the CMS",
           'Content' => "Eget aliquet nibh praesent tristique magna sit amet purus. Semper viverra nam libero justo laoreet sit amet cursus sit. Ultricies mi quis hendrerit dolor magna eget. Mollis aliquam ut porttitor leo a diam sollicitudin tempor id. Suspendisse ultrices gravida dictum fusce. Euismod elementum nisi quis eleifend quam adipiscing vitae. Odio aenean sed adipiscing diam donec. Sapien pellentesque habitant morbi tristique senectus et netus. Tristique senectus et netus et malesuada fames ac turpis egestas. In iaculis nunc sed augue. Ac tortor dignissim convallis aenean et tortor at risus viverra. Porta non pulvinar neque laoreet suspendisse interdum consectetur. Erat pellentesque adipiscing commodo elit at imperdiet. Venenatis cras sed felis eget velit. Rutrum quisque non tellus orci. Id diam maecenas ultricies mi eget mauris. Donec massa sapien faucibus et.",
    ); 
    
	function getCMSFields() {
		$fields = parent::getCMSFields();
        $fields->removeByName("LinkTracking");
        $fields->removeByName("FileTracking");		
		$fields->replaceField("Content", new HTMLEditorField("Content"));
		return $fields;
	}
}