<?php
use SilverStripe\ORM\DataObject;
use SilverStripe\Assets\Image;
use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Forms\TextField;
use SilverStripe\AssetAdmin\Forms\UploadField;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;
use SilverStripe\Forms\DropdownField;

class BlockWidgetServiceCarouselItems extends DataObject {

    private static $singular_name = "Service Item";

    private static $db = array(
        "Title"         => "Varchar",
        "Content"       => "HTMLText",
        "Sort"          => "Int",
        "ButtonText"    => "Varchar",

    );

    private static $default_sort = "Sort";
    
    private static $defaults = array(
           'Title'      => "Enter a title in the CMS",
           'Content'    => "Mauris urna erat hendrerit potenti phasellus est. Cursus venenatis porttitor mauris aliquam scelerisque donec amet. At venenatis himenaeos imperdiet erat. Dignissim aenean commodo tristique integer gravida posuere consectetuer taciti.",         
           'ButtonText' => "More Information",        
    );

    private static $has_one = array(
        "BlockWidgetServiceCarousel"        => BlockWidgetServiceCarousel::class,
        "TargetPage"                             => SiteTree::class,
        "FontAwsomeIcon"                    => FontAwsomeIcon::class,
        
    );
    
    // private static $owns = [
    //     'Image'
    // ];

    public function getCMSFields(){

        $fields = parent::getCMSFields();
        $fields->removeByName("BlockWidgetServiceCarouselID");
        $fields->removeByName("Sort");
        $fields->addFieldToTab("Root.Main", new TextField("Title", "Title"));

        $Data = DataObject::get('FontAwsomeIcon', '', 'Icon ASC'); 
        $Source = $Data->map('ID','Icon'); 
        $field = new DropdownField('FontAwsomeIconID', 'Icon', $Source);
        $field->setEmptyString('(Select one)');
        $fields->addFieldToTab('Root.Main', $field); 

        $fields->addFieldToTab("Root.Main", new TextField("ButtonText", "ButtonText"));

        $fields->addFieldToTab("Root.Main", $target = DropdownField::create("TargetPageID", "TargetPage", Page::get()->sort("Title")->map()->toArray()));
        $target->setEmptyString("Select a target page");

        $fields->addFieldToTab("Root.Main", new HTMLEditorField("Content", "Content"));
        return $fields;
    }

}
