<?php
use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\AssetAdmin\Forms\UploadField;
use TractorCow\Colorpicker\Forms\ColorField;
use SilverStripe\View\Requirements;
use SilverStripe\Assets\Image;

use SilverStripe\Forms\GridField\GridFieldConfig;
use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
use SilverStripe\Forms\GridField\GridField;

class BlockWidgetOurCapabilities extends PageBlock {

    private static $singular_name = "Our Capabilities Block";

    private static $db = array(
        "Sort"     => "Int",
    );

    private static $fullOnly = true;

    private static $default_sort = "Sort";

    private static $has_many = array(
        "Items" => BlockWidgetOurCapabilitiesItems::class
    );

    private static $has_one = array(
    );

    public function getCMSFields(){

        $fields = parent::getCMSFields();
        $fields->removeByName("Sort");
        $fields->removeByName("Items");
        if ($this->ID > 0){
            $gridFieldConfig = GridFieldConfig_RecordEditor::create();
            $gridFieldConfig->addComponent(new GridFieldOrderableRows('Sort'));
            $grid = new GridField("Items", "Items", $this->Items(), $gridFieldConfig);
            $fields->addFieldToTab("Root.Main", $grid);
        }        
        return $fields;
    }

}
