<?php
use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\Assets\Image;
use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Forms\TextField;
use SilverStripe\Forms\TreeDropdownField;
use SilverStripe\AssetAdmin\Forms\UploadField;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;
use SilverStripe\Forms\DropdownField;
use SilverStripe\ORM\DataObject;

class BlockWidgetFeatureText extends PageBlock {

    private static $singular_name = "Feature Text Block";

    private static $db = array(
        "Title"             => "Varchar",
        "Content"           => "HTMLText",
    );

    private static $allowed_page_types = array(
    );

    private static $has_one = array(
        "FontAwsomeIcon" => FontAwsomeIcon::class,
    );
    
    private static $owns = [
    ];

    public function getCMSFields(){

        $fields = parent::getCMSFields();
        $fields->removeByName("IconImage");
        $fields->removeByName("Sort");

        $fields->addFieldToTab("Root.Main", new TextField("Title", "Title"));

        //icon
        $Data = DataObject::get('FontAwsomeIcon', '', 'Icon ASC'); 
        $Source = $Data->map('ID','Icon'); 
        $field = new DropdownField('FontAwsomeIconID', 'Icon', $Source);
        $field->setEmptyString('(Select one)');
        $fields->addFieldToTab('Root.Main', $field);


        $HTML = HTMLEditorField::create('Content', 'Content')
            ->setRows(5);
        $fields->addFieldToTab('Root.Main', $HTML);

        return $fields;
    }

}
