<?php
use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\Assets\Image;
use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Forms\TextField;
use SilverStripe\Forms\TreeDropdownField;
use SilverStripe\AssetAdmin\Forms\UploadField;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;
use SilverStripe\Forms\DropdownField;
use SilverStripe\ORM\DataObject;
use SilverStripe\Forms\LiteralField;

class FontAwsomeIcon extends DataObject {

    private static $singular_name = "Icon";

    private static $db = array(
        "IconCode"         => "Varchar",
        "Icon"             => "Varchar",
        "Help"             => "Varchar",
    );

    private static $summary_fields = array(
        "Icon" => "Name",
        "IconCode",
    );

    public function getCMSFields(){

        $fields = parent::getCMSFields();

        $fields->addFieldToTab("Root.Main", new TextField("Icon", "Icon name"));
        $fields->addFieldToTab("Root.Main", new TextField("IconCode", "Icon class"));
        
        $fields->addFieldToTab("Root.Main", new LiteralField("Help", '<p>You can get new icons from this <a href="https://fontawesome.com/icons?d=gallery&m=free">link</a> please copy the class name for it to work.</p><br><p>An example class name is <span style="font-weight:700;">fas fa-arrow-up</span></p><br><p> To see what icon you have inserted please click save and it will appear below. If it doesnt appear it will not work<br><br> <i style="font-size: 60px;"class="'.$this->IconCode.'"></i> '));

        // $fields->addFieldToTab("Root.Main", $Name        = LiteralField::create("Icon"));
        // if(!empty($this->Icon)){ //if value is set then make field read only.
        //     $Name->setReadonly(true);
        // }

        return $fields;
    }


    public function onBeforeWrite(){
        // $Icon = '<i style="font-size: 30px;"class="'.$this->IconCode.'"></i>';
        // $convert = htmlspecialchars_decode($Icon);
        // $this->Icon = $convert;
        // $fields->addFieldToTab("Root.Main", new LiteralField("Icon", '<i style="font-size: 30px;"class="'.$this->IconCode.'"></i> '));
        parent::onBeforeWrite();
    }        


}


