<?php

use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\Assets\Image;
use SilverStripe\Forms\DropdownField;
use SilverStripe\Control\Controller;
use SilverStripe\Forms\TextField;


class BlockWidgetInternalBanner extends PageBlock {

    private static $singular_name = "Internal Banner Block";

    private static $db = array(
        "Title"     =>  "Varchar(255)",
        // "SubTitle"  =>  "Varchar(255)",
        // "Layout"          => "Enum(array('Layout1','Layout2'))",
    );

    // public function getLayoutStyle(){
    //     switch($this->Layout){
    //         case "Layout1":
    //             return "Layout1";
    //         case "Layout2":
    //             return "Layout2";
    //     }
    // }    

    private static $fullOnly = true;

    private static $allowed_page_types = array();

    private static $has_one = array(
        "Image"    => Image::class,
    );

    private static $owns = [
        'Image'
    ];

    public function getPageClassName(){
        $fields = Controller::curr()->getClassName();
        return $fields;
    }

    public function getCMSFields(){
        $fields = parent::getCMSFields();
        $fields->removeByName("LinkTracking");
        $fields->removeByName("FileTracking");    
        $fields->addFieldToTab("Root.Main", new TextField("Title", "Title (Overwrites page)"));
        // $fields->addFieldToTab("Root.Main", new TextField("SubTitle", "Sub Title (Overwrites page)"));

        // $fields->addFieldToTab('Root.Main', new DropdownField(
        //       'Layout',
        //       'Internal banner style',
        //       singleton('BlockWidgetInternalBanner')->dbObject('Layout')->enumValues()
        // ));            
        return $fields;
    }

    public function Output()
        {
    //      Requirements::css("themes/" . Config::inst()->get('SSViewer', 'theme') . "/css/.css");;;
    //      Requirements::javascript("themes/" . Config::inst()->get('SSViewer', 'theme') . "/javascript/.js");
            return parent::Output();
        }

}