<?php
namespace FormFields;

use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Control\Controller;
use SilverStripe\Forms\TextField;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;
use SilverStripe\Control\Session;
use SilverStripe\Forms\GridField\GridFieldConfig_RecordEditor;
use Symbiote\GridFieldExtensions\GridFieldAddNewMultiClass;
use SilverStripe\Core\ClassInfo;
use Symbiote\GridFieldExtensions\GridFieldEditableColumns;
use Symbiote\GridFieldExtensions\GridFieldOrderableRows;
use SilverStripe\Forms\GridField\GridField;
use SilverStripe\Forms\TreeDropdownField;
use SilverStripe\View\Requirements;
use SilverStripe\Forms\GridField\GridFieldAddNewButton;
use SilverStripe\Forms\GridField\GridFieldDataColumns;
use FormFields\CustomisableFormField;
use FormFields\CustomisableFormPanel;
use FormFields\CustominsableFormRecipient;
use SilverStripe\Forms\TabSet;

class BlockWidgetCustomisableForm extends PageBlock
{
	private static $singular_name = "Customisable Form";

	private static $db = array(
		// "Title"         => "Varchar(100)",
		// "Content"       => "HTMLText",
		"SuccessMessage"=> "HTMLText",
		"FromAddress"   => "Varchar(100)",
		"Subject"       => "Varchar(100)",
	);

	private static $table_name = 'BlockWidgetCustomisableForm';
	
	private static $fullOnly = false;

	private static $customCSS = false;

	private static $allowed_page_types = array();

	private static $has_many = array(
		"FormPanels"    => CustomisableFormPanel::class,
		"Recipients"    => CustominsableFormRecipient::class
	);

	private static $has_one = array(
		"TargetPage"   => SiteTree::class,
	);

	public function getCMSActions() {
		$actions = parent::getCMSActions();

		$bookAction = new FormAction ('doAddPanel', 'Add Form Panel');
		$bookAction->addExtraClass('ss-ui-action-constructive');
		$actions->push($bookAction);

		return $actions;
	}

	public function getMultiTab(){
		return $this->FormPanels()->count() > 1;
	}

	public function getCMSFields(){
		$fields = parent::getCMSFields();
		$fields->removeByName("PageBlockRowID");
		//DB FIELDS
        // $fields->addFieldToTab("Root.Main", new TextField("Title", "Title"));
        // $fields->addFieldToTab("Root.Main", new TextField("ButtonTextTitle", "ButtonText"));
        // $fields->addFieldToTab("Root.Main", new HtmlEditorField("Content", "Content"));
        $fields->addFieldToTab("Root.Fields", new TextField("FromAddress", "FromAddress"));
        $fields->addFieldToTab("Root.Fields", new TextField("Subject", "Subject"));
        $fields->addFieldToTab("Root.SuccessMessage", $successField = HtmlEditorField::create("SuccessMessage", "SuccessMessage"));
		$successField->setRightTitle("This will be ignored it a success page has been set.");
//		add new multi class, remove base class and just show extensions
		if ($this->ID){
			$fields->removeByName("FormPanels");
			if ($this->FormPanels()->count() > 0){
				if ($this->getMultiTab()){
					$fields->addFieldToTab('Root', new TabSet('Fields'), "Recipients");
				}
				foreach($this->FormPanels() as $panel){
					$gridFieldConfig = GridFieldConfig_RecordEditor::create();

//					Gridfield inline multi add new.
					$gridFieldConfig->addComponent($multiField = new GridFieldAddNewMultiClass('buttons-before-left'));
					$classes = $this->getFieldClasses();
					$addNew = $gridFieldConfig->getComponentByType(GridFieldAddNewMultiClass::class);
					$addNew->setClasses(array_values($classes));

					$gridFieldConfig->removeComponentsByType(GridFieldAddNewButton::class);
					$gridFieldConfig->removeComponentsByType(GridFieldDataColumns::class);

					$gridFieldConfig->addComponent(new GridFieldEditableColumns());
					$gridFieldConfig->addComponent(new GridFieldOrderableRows());

					$panelTitle = $this->getMultiTab()? "{$panel->Title} Fields": "Fields";
					$addNew->setTitle("Add To {$panelTitle}");
					$grid = new GridField("FormFields-{$panel->ID}", $panelTitle, $panel->FormFields(), $gridFieldConfig);
					$grid->getConfig()->getComponentByType(GridFieldEditableColumns::class)->setDisplayFields(array(
						'Title'  => function($record, $column, $grid) {
							return new TextField($column, "");
						},
						"FieldTypeName"  => "FieldTypeName"

					));

					if ($this->getMultiTab()){
						$fields->addFieldToTab("Root.Fields.{$panel->Title}", $grid);
					} else {
						$fields->addFieldToTab("Root.Fields", $grid);
					}

				}
			}

			$gridFieldConfig = GridFieldConfig_RecordEditor::create();
			$gridFieldConfig->addComponent(new GridFieldOrderableRows());
			$grid = new GridField("FormPanels", "Panels", $this->FormPanels(), $gridFieldConfig);
			// echo '<pre>' . print_r($grid, true) . '</pre>';die();					

			$fields->addFieldToTab("Root.Main", $targetField = TreeDropdownField::create("TargetPageID", "Choose success page:", SiteTree::class));
			$targetField->setRightTitle("Leave blank to return to the page the form is on to display the success message.");
			// $fields->addFieldToTab("Root.Panels", $grid);
		}
		return $fields;
	}

	public function getFieldClasses(){
		$classes = ClassInfo::subclassesFor(CustomisableFormField::class);
		$classes = array_combine(array_values($classes), array_values($classes)); //Makes key and value the same
		unset($classes[CustomisableFormField::class]); // Removes CustomisableFormField as a class
		asort($classes); //alphabetical order
		foreach($classes as $className => $class){
			if (singleton($className)->stat("remove_from_list")){
				unset($classes[$className]);
			}
		}
		// echo '<pre>' . print_r($classes, true) . '</pre>';die();		
		return $classes;
	}

	public function Output(){
		Requirements::set_force_js_to_bottom(true);
		Requirements::css(CUSTOM_FORM_MODULE_DIR . '/css/GenericStyles.css');
		// Requirements::css(CUSTOM_FORM_MODULE_DIR . '/css/InputStyles.css');
		Requirements::css(CUSTOM_FORM_MODULE_DIR . '/css/cms.css');
		$this->extend('Output');
		return parent::Output();
	}

	public function getSubmitLink(){
		$link = $this->PageBlockRow()->Page()->Link();
		$link = $link . "submitForm/{$this->ID}";
		return $link;
	}

	public function getHasUpload(){
//		loop all child fields and see if any have has_upload = true;
		$has_upload = $this->stat("has_upload");
		foreach($this->FormPanels() as $panel){
			foreach($panel->FormFields() as $field){
				if (singleton($field->ClassName)->stat("has_upload")){
					$has_upload = true;
				}
			}
		}
		return $has_upload;
	}

	public function onBeforeWrite(){
		parent::onBeforeWrite();
		$session = Controller::curr()->getRequest()->getSession();
	//		check if page new
		if (!$this->owner->isInDB()){
			$session->set("CreateDefaultFields", true);
		}
	}

	public function onAfterWrite(){
		//rootPanel
		$session = Controller::curr()->getRequest()->getSession();
		if ($session->get("CreateDefaultFields")){
			$session->clear("CreateDefaultFields");
			$panel = new CustomisableFormPanel();
			$panel->Title = "Root";
			$panel->write();
			$this->FormPanels()->add($panel);

			//define
            $class = $this->owner->ClassName;
            //Fields has the whole array stored inside it
            $Fields = $class::config()->default_fields;

            if (count($Fields) > 0){

            	//$Field returns "text field" & FieldDefinition returns the "Text Field" array
                foreach($Fields as $FieldName => $FieldDefinition){
                	//Field type returns "CustomisableTextField" & FieldOptions returns the "CustomisableTextFeld" array with options inside
                	foreach($FieldDefinition as $FieldType => $FieldOptions){
                		if (class_exists($FieldType)){
                			if ($newField = new $FieldType){
                				//Title,Length,Float are names of fields in formfields
                				//$FieldOptions["Length"]; means get the value of Length in the FieldOptions array
	                            $newField->Title = $FieldName;

	                            if (array_key_exists('Length', $FieldOptions)) {
   							 		$newField->Length = $FieldOptions["Length"];
								}
	                            if (array_key_exists('Float', $FieldOptions)) {
   							 		$newField->Float = $FieldOptions["Float"];
								}
	                            if (array_key_exists('Required', $FieldOptions)) {
   							 		$newField->Required = $FieldOptions["Required"];
								}
	                            $newField->write();
	                            $panel->FormFields()->add($newField);
								// echo '<pre>' . print_r($panel, true) . '</pre>';die();
	                            
                			}
                			// clears field
                			unset($newField);
                		} else {
                		   // echo '<pre>' . print_r($FieldType, true) . '</pre>';
                		   echo '<pre>' . print_r("Died", true) . '</pre>';
						   die();
                		}
					}

                    }

                }
            }
            parent::onAfterWrite();
	}

	public function Success(){
		$session = Controller::curr()->getRequest()->getSession();
		if ($session->get("MessageSent")){
			if ($session->get("MessageSent") == $this->ID){
				$session->clear("MessageSent");
				return true;
			}
		}
	}
}