<?php
namespace FormFields;
use FormFields\CustomisableFormField;
use SilverStripe\Forms\DateField;
use SilverStripe\Forms\TextField;
use SilverStripe\View\Requirements;

class CustomisableDateField extends CustomisableFormField
{
	private static $singular_name = "Date Field";

	private static $db = array(
		"ShowCalendar"  => "Boolean"
	);

	private static $table_name = 'CustomisableDateField';
		
	private static $has_one = array();

	private static $has_many = array();

	// private static $base_field_type = DateField::class;
	private static $base_field_type = TextField::class; //Made it a text field class so jquery UI could work because HTML5 date field type messes it up

	public function getCMSFields()
	{
		$fields = parent::getCMSFields();
		//this removes the float and position from unwanted fields
		$fields->removeByName("Icon");
		$fields->removeByName("Float");

		return $fields;
	}

	public function getCustomField(){
		// $field = parent::getCustomField();
		Requirements::css('BlockWidgetCustomisableForm/css/jquery-ui.min.css');
		Requirements::javascript('BlockWidgetCustomisableForm/javascript/jquery-ui.min.js');
		Requirements::javascript('BlockWidgetCustomisableForm/javascript/DatePicker.js');
		$fieldType = $this->stat('base_field_type'); //gets SilverStripe\Forms\TextField
		$field = new $fieldType($this->getDataFieldTitle(), $this->Title, $value = ''); //creates SilverStripe\Forms\TextField Object ()
		$field->setAttribute("placeholder", $this->Title);
		$field->setAttribute("datepicker", $this->Title);
		if ($this->Required){
			$field->setAttribute("required", "required");
		}
		return $field;


		// $field->setConfig("showcalendar", true);
		return $field;
	}


}