<?php
namespace FormFields;

use SilverStripe\ORM\DataObject;
use SilverStripe\Forms\GridField\GridFieldConfig_RelationEditor;
use SilverStripe\Forms\GridField\GridFieldAddNewButton;
use SilverStripe\Forms\GridField\GridFieldEditButton;
use SilverStripe\Forms\GridField\GridFieldDataColumns;
use SilverStripe\Forms\GridField\GridFieldConfig;
use SilverStripe\Forms\GridField\GridField;
use FormFields\CustomisableFormOptionFieldItem;
use SilverStripe\Forms\GridField\GridFieldAddExistingAutocompleter;

class CustomisableFormOptionFieldItem extends DataObject
{
	private static $singular_name = "Option";

	private static $db = array(
		"Title" => "Varchar",
		"Sort"  => "Int"
	);

	private static $table_name = 'CustomisableFormOptionFieldItem';
	
	private static $default_sort = "Sort";

	private static $has_one = array(
		"Field"                 => CustomisableFormOptionField::class
	);



	private static $has_many = array();

	public function getSearchTitle(){
		return $this->Field()->Title . ': ' . $this->Title;
	}

	public function getCMSFields(){
		$fields = parent::getCMSFields();
		$fields->removeByName("Sort");
		return $fields;
	}
}