<?php
use SilverStripe\ORM\DataObject;
use SilverStripe\Assets\Image;
use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Forms\TextField;
use SilverStripe\AssetAdmin\Forms\UploadField;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;

class BlockWidgetChecklistItem extends DataObject {


    private static $db = array(
        "Title" => "Varchar",
        "Sort"     => "Int",
    );

    private static $default_sort = "Sort";
    
    private static $allowed_page_types = array(
    );

    private static $has_many = array(
    );

    private static $has_one = array(
        "BlockWidgetChecklist"  => "BlockWidgetChecklist",
        "Image"                 => Image::class,
        "FontAwsomeIcon"        => FontAwsomeIcon::class,
    );
    
    private static $owns = [
        'Image'
    ];

    public function getCMSFields(){

        $fields = parent::getCMSFields();
        $fields->removeByName("Sort");
        $fields->addFieldToTab("Root.Main", new TextField("Title", "Title"));
        return $fields;
    }

}
