<?php

use SilverStripe\ORM\DataExtension;
use SilverStripe\Forms\FieldList;
use SilverStripe\Control\Controller;
use SilverStripe\SiteConfig\SiteConfig;
use SilverStripe\Control\HTTPRequest;
use SilverStripe\Core\Injector\Injector;
use SilverStripe\Control\Email\Email;

class TestimonialsSubmissionExtension extends DataExtension {

	private static $allowed_actions = array(
		"SubmitTestimonial"
	);

	public function SubmitTestimonial(){
		if (!isset($_REQUEST["message"]) || strlen($_REQUEST["message"]) == 0){
			$data = Controller::curr()->getRequest()->postVars();
			$testimonialsPage = TestimonialsPage::get()->First();
			$testimonial = new TestimonialItem();
			$testimonial->Title         = $data["title"];
			$testimonial->Author        = $data["name"];
			$testimonial->Location      = $data["location"];
			$testimonial->Content       = $data["Content"];
			$testimonial->Rating        = $data["Rating"];
			$testimonial->Approved      = false;
			$testimonial->PageID        = $testimonialsPage->ID;
			$testimonial->write();
		}
//		send an email to the selected recipient.
		$recipients = SiteConfig::current_site_config()->TestimonialsRecipients();
		if ($recipients->count() > 0){
			$From       = SiteConfig::current_site_config()->TestimonialsNotificationFrom;
			$Subject    = "New Testimonial Submission";
			foreach($recipients as $recipient){
				$To = $recipient->Email;
				$data = $testimonial;
				$email = new Email($From, $To, $Subject);
				//set template
				$email->setHTMLTemplate('Email\TestimonialsSubmission');
				$email->setData($data);
				$email->send();
			}
		}
		$request = Injector::inst()->get(HTTPRequest::class);
        $session = $request->getSession();		
		$session->set("TestimonialSuccess", true);
		Controller::curr()->redirectBack();
	}
}