<?php

use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\View\Requirements;
use SilverStripe\Control\Session;
use SilverStripe\Control\HTTPRequest;
use SilverStripe\Core\Injector\Injector;
use SilverStripe\ORM\ArrayList;
use SilverStripe\View\ArrayData;

class BlockWidgetTestimonialForm extends PageBlock
{
    private static $singular_name = "Testimonial Submit Block";

    private static $db = array(
        "SuccessMessage"    => "HTMLText"
    );

    private static $fullOnly = false;

    private static $has_one = array(
    );

    public function getRatings(){

        $ratings = new ArrayList();
        foreach(singleton('TestimonialItem')->dbObject('Rating')->enumValues() as $rating) {
            $ratings->push(new ArrayData(array(
                'ID' => $rating,
                'Title' => "{$rating} Star" . ($rating > 1 ? "s" : "")
            )));
        }
        // echo '<pre>' . print_r($ratings, true) . '</pre>';die();
        return $ratings;
    }

    public function getCMSFields(){
        $fields = parent::getCMSFields();
        return $fields;
    }

    public function getSuccess(){
        $request = Injector::inst()->get(HTTPRequest::class);
        $session = $request->getSession();

        $result = false;
        if ($session->get("TestimonialSuccess")){
            $result = true;
            $session->clear("TestimonialSuccess");
        }
        return $result;
    }

    public function Output(){
        Requirements::css('BlockModuleTestimonials/css/Tabs.css');
        return parent::Output();
    }

}