<?php
use NewedgeMedia\BlockBuilder\PageBlock;
use SilverStripe\Assets\Image;
use SilverStripe\CMS\Model\SiteTree;
use SilverStripe\Forms\TextField;
use SilverStripe\Forms\TreeDropdownField;
use SilverStripe\AssetAdmin\Forms\UploadField;
use TractorCow\Colorpicker\Forms\ColorField;
use SilverStripe\Forms\DropdownField;
use SilverStripe\Forms\HTMLEditor\HTMLEditorField;

class BlockWidgetFullWidthCTA extends PageBlock {

    private static $singular_name = "Full Width CTA Block";

    private static $db = array(
        "Title"       => "Varchar(50)",
        "ButtonText"   => "HTMLText",
        "Description"   => "HTMLText",
        "BackgroundColour" => "Color",
        // "Icon"          => "Enum(array('Construction','Repairs', 'Property'))",

    );

    // public function getDisplayIcon(){
    //     switch($this->Icon){
    //         case "Construction":
    //             return "public/resources/images/icons/services/construction.svg";
    //         case "Repairs":
    //             return "public/resources/images/icons/services/construction.svg";
    //         case "Property":
    //             return "public/resources/images/icons/services/construction.svg";
    //     }
    // }

    private static $defaults = array(
           'Title'              => "See what our customers say about us",
           'Description'        => "<p>Fusce id velit ut tortor pretium viverra suspendisse. Ipsum dolor sit amet consectetur adipiscing elit pellentesque.<p>",
           'ButtonText'         => "Contact Us"
    );

    private static $fullOnly = true;

    private static $has_one = array(
        "TargetPage"    => SiteTree::class,
        // "Image"         => Image::class,
    );
    
    // private static $owns = [
    //     'Image'
    // ];

    public function getCMSFields()
        {
            $fields = parent::getCMSFields();
            $fields->removeByName("LinkTracking");
            $fields->removeByName("FileTracking");            
            $fields->addFieldToTab("Root.Main", new TextField("Title", "Title"));
            $fields->addFieldToTab("Root.Main", new HTMLEditorField("Description", "Description"));
            // $fields->addFieldToTab('Root.Main', new DropdownField(
            //       'Icon',
            //       'Icon',
            //       singleton('BlockWidgetFullWidthCTA')->dbObject('Icon')->enumValues()
            // ));            
            $fields->addFieldToTab("Root.Main", new TextField("ButtonText", "ButtonText"));
            $fields->addFieldToTab("Root.Main", $target = DropdownField::create("TargetPageID", "TargetPage", Page::get()->sort("Title")->map()->toArray()));
            $target->setEmptyString("Select a target page");
            $fields->addFieldToTab("Root.Colour", new ColorField ("BackgroundColour", "CTA background colour (optional)"));
            // $fields->addFieldToTab("Root.Main", new UploadField("Image", "Image"));
            // $fields->removeByName("Icon");            
            return $fields;
        }

}
